
Class PhysicsTerrain ' WIP

	Field terrain:Model
	Field pixels:Pixmap

	Field heightmap:Pixmap
	Field terrain_material:PbrMaterial

	Field height_box:Boxf

	Field collider:TerrainCollider		' Bullet physics collider
	Field body:RigidBody				' Bullet physics body

	Method LoadTerrain:Model (hmap:String, color_map:Pixmap)

		heightmap = Pixmap.Load (hmap)
		
		If heightmap.Format <> PixelFormat.I8
			Print ""
			Print "*** MEDIA WARNING: Converting heightmap; should be supplied in PixelFormat.I8 format! (See PixelFormat docs.) ***"
			Print ""
			heightmap = heightmap.Convert (PixelFormat.I8)
			'Print heightmap.Save ("C:/Users/James/Desktop/height.png") ' Returns True if saved to asset:: even though it fails!
		Endif
		
		Local terrain_material:PbrMaterial = New PbrMaterial ()
		terrain_material.ColorTexture = New Texture (color_map, TextureFlags.None)
		
		Local terrain_height:Float = 64.0
		
		height_box = New Boxf (-heightmap.Width * 0.5, 0, -heightmap.Height * 0.5, heightmap.Width * 0.5, terrain_height, heightmap.Height * 0.5)

		terrain = Model.CreateTerrain (heightmap, height_box, terrain_material)

		collider	= terrain.AddComponent <TerrainCollider> ()
		body		= terrain.AddComponent <RigidBody> ()

		collider.Heightmap	= heightmap
		collider.Bounds		= height_box
		
		body.Mass = 0.0

		body.CollisionMask	= COLL_TERRAIN
		body.CollisionGroup	= TERRAIN_COLLIDES_WITH
		
		Return terrain
		
	End
	
End
